<?php $__env->startSection('title', 'Dashboard'); ?>

<?php $__env->startSection('content'); ?>
<h1 class="h3 mb-4">Dashboard</h1>

<div class="row g-4 mb-4">
    <div class="col-md-3">
        <div class="card">
            <div class="card-body">
                <h5 class="card-title">Total Doctors</h5>
                <h2 class="mb-0"><?php echo e($stats['total_doctors']); ?></h2>
                <small class="text-muted"><?php echo e($stats['active_doctors']); ?> active</small>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card">
            <div class="card-body">
                <h5 class="card-title">Total Services</h5>
                <h2 class="mb-0"><?php echo e($stats['total_services']); ?></h2>
                <small class="text-muted"><?php echo e($stats['active_services']); ?> active</small>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card">
            <div class="card-body">
                <h5 class="card-title">Appointments</h5>
                <h2 class="mb-0"><?php echo e($stats['total_appointments']); ?></h2>
                <small class="text-muted"><?php echo e($stats['pending_appointments']); ?> pending</small>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card">
            <div class="card-body">
                <h5 class="card-title">Unread Messages</h5>
                <h2 class="mb-0"><?php echo e($stats['unread_messages']); ?></h2>
            </div>
        </div>
    </div>
</div>

<div class="row g-4 mb-4">
    <div class="col-md-3">
        <div class="card">
            <div class="card-body">
                <h5 class="card-title">Blog Posts</h5>
                <h2 class="mb-0"><?php echo e($stats['total_blogs']); ?></h2>
                <small class="text-muted"><?php echo e($stats['published_blogs']); ?> published</small>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card">
            <div class="card-body">
                <h5 class="card-title">Testimonials</h5>
                <h2 class="mb-0"><?php echo e($stats['total_testimonials']); ?></h2>
                <small class="text-muted"><?php echo e($stats['active_testimonials']); ?> active</small>
            </div>
        </div>
    </div>
</div>

<div class="card">
    <div class="card-header">
        <h5 class="mb-0">Recent Appointments</h5>
    </div>
    <div class="card-body">
        <?php if($recentAppointments->count() > 0): ?>
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Patient Name</th>
                        <th>Email</th>
                        <th>Phone</th>
                        <th>Preferred Time</th>
                        <th>Doctor</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $recentAppointments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $appointment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($appointment->name); ?></td>
                        <td><?php echo e($appointment->email); ?></td>
                        <td><?php echo e($appointment->phone); ?></td>
                        <td><?php echo e($appointment->preferred_time->format('M d, Y h:i A')); ?></td>
                        <td><?php echo e($appointment->doctor ? $appointment->doctor->name : 'Any Doctor'); ?></td>
                        <td>
                            <span class="badge bg-<?php echo e($appointment->status == 'pending' ? 'warning' : ($appointment->status == 'confirmed' ? 'success' : 'danger')); ?>">
                                <?php echo e(ucfirst($appointment->status)); ?>

                            </span>
                        </td>
                        <td>
                            <a href="<?php echo e(route('admin.appointments.show', $appointment)); ?>" class="btn btn-sm btn-primary">
                                <i class="bi bi-eye"></i> View
                            </a>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
        <?php else: ?>
        <p class="text-muted mb-0">No appointments yet.</p>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/sumankc/Desktop/ENT Care/resources/views/admin/dashboard.blade.php ENDPATH**/ ?>